document.getElementById('crawlBtn').addEventListener('click', async () => {
    const status = document.getElementById('status');
    status.textContent = 'Crawling...';

    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

    chrome.tabs.sendMessage(tab.id, { action: 'crawl_page' }, (response) => {
        if (chrome.runtime.lastError) {
            status.textContent = 'Error: ' + chrome.runtime.lastError.message;
        } else {
            status.textContent = response && response.status ? response.status : 'Done!';
        }
    });
});



document.getElementById('builderBtn').addEventListener('click', async () => {
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    chrome.tabs.sendMessage(tab.id, { action: 'toggle_sidebar' });
    window.close(); // Close popup so user can interact with sidebar
});
